﻿/***************************************************************************/
/**                                                                       **/
/**                               MAGICARD                                **/
/**                                                                       **/
/***************************************************************************/
/**                                                                       **/
/**  PROJECT      : SDK C# Demo - DTC Printers                            **/
/**                                                                       **/
/**  MODULE NAME  : Driver1.cs                                            **/
/**                                                                       **/
/**  COPYRIGHT    : Magicard                                              **/
/**                                                                       **/
/***************************************************************************/
using System;
using System.Windows.Forms;
using System.Collections.Generic;
using SDKShim;

namespace CSharpDemo
{
    public partial class SDK_CSDemo : Form
    {
        #region === Initialisation ===

        private void InitDriver1Tab()
        {
            InitCorrectionCombos();
            InitPrintSpeedCombo();
            InitSideCombos();
            InitAreaHoleCombo();
        }

        Dictionary<SDK.Side, string> sidekp = new Dictionary<SDK.Side, string>()
        {
            {SDK.Side.Front, "Front"},  
            {SDK.Side.Back,  "Back"}, 
        };

        private void InitSideCombos()
        {
            ResinAreaSideCombo.DataSource       = new BindingSource(sidekp, null);
            ResinAreaSideCombo.DisplayMember    = "Value";
            AreaHoleSideCombo.DataSource        = new BindingSource(sidekp, null);
            AreaHoleSideCombo.DisplayMember     = "Value";
            CardSettingsSideCombo.DataSource    = new BindingSource(sidekp, null);
            CardSettingsSideCombo.DisplayMember = "Value";
            HoloKoteSideCombo.DataSource        = new BindingSource(sidekp, null);
            HoloKoteSideCombo.DisplayMember     = "Value";
            ColourAreaSideCombo.DataSource      = new BindingSource(sidekp, null);
            ColourAreaSideCombo.DisplayMember   = "Value";
            ColourAreaSideCombo.DataSource      = new BindingSource(sidekp, null);
            ColourAreaSideCombo.DisplayMember   = "Value";
            ResinOptionsSideCombo.DataSource    = new BindingSource(sidekp, null);
            ResinOptionsSideCombo.DisplayMember = "Value";
        }

        Dictionary<SDK.AreaHole, string> areaholekp = new Dictionary<SDK.AreaHole, string>()
        {
            {SDK.AreaHole.Area, "Area"},  
            {SDK.AreaHole.Hole, "Hole"}, 
        };

        private void InitAreaHoleCombo()
        {
            AreaHoleTypeCombo.DataSource = new BindingSource(areaholekp, null);
            AreaHoleTypeCombo.DisplayMember = "Value";
        }

        #endregion === Initialisation ===

        //----------------------------------------------------------------------

        #region === Local Methods ===

        private void Driver1Controls(bool control)
        {
            GUIUser.Enabled               = control;
            GUIPrinter.Enabled            = control;
            SharpnessUpDown.Enabled       = control;
            CorrectionCombo.Enabled       = control;
            YMCPowerUpDown.Enabled        = control;
            ResinPowerUpDown.Enabled      = control;
            OvercoatPowerUpDown.Enabled   = control;
            ResinAreaLeftUpDown.Enabled   = control;
            ResinAreaWidthUpDown.Enabled  = control;
            ResinAreaBottomUpDown.Enabled = control;
            ResinAreaHeightUpDown.Enabled = control;
            AreaHoleLeftUpDown.Enabled    = control;
            AreaHoleWidthUpDown.Enabled   = control;
            AreaHoleBottomUpDown.Enabled  = control;
            AreaHoleHeightUpDown.Enabled  = control;
            EraseAreaLeftUpDown.Enabled   = control;
            EraseAreaWidthUpDown.Enabled  = control;
            EraseAreaBottomUpDown.Enabled = control;
            EraseAreaHeightUpDown.Enabled = control;
            ErasePowerStartUpDown.Enabled = control;
            ErasePowerEndUpDown.Enabled   = control;
            WritePowerUpDown.Enabled      = control;
            EraseBeforePrint.Enabled      = control;

            switch (printerType)
            {
            case SDK.PrinterType.Enduro:
                PrintSpeedCombo.Enabled = control;
                break;
            case SDK.PrinterType.Generation2:
                PrintableAreaLeftUpDown.Enabled   = control;
                PrintableAreaWidthUpDown.Enabled  = control;
                PrintableAreaBottomUpDown.Enabled = control;
                PrintableAreaHeightUpDown.Enabled = control;

                if (PrinterIs600DPICapable())
	            {
                    Radio300DPI.Enabled = control;
                    Radio600DPI.Enabled = control;
                }
                break;
            }
        }

        private bool PrinterIs600DPICapable()
        {
            if (printerType != SDK.PrinterType.Generation2)
	        {
		        return false;
	        }

            return SDK.ID_PrinterModel(hSession).HasFlag(SDK.Model.Fn_600dpi);
        }

        private bool Driver1ActionIsGet()
        {
            return Driver1GetRadio.Checked;
        }

        private void ClearDriver1MsgBoxButton_Click(object sender, EventArgs e)
        {
            Driver1MsgBox.Clear();
        }

        private void Driver1ActionGetRadio_CheckedChanged(object sender, EventArgs e)
        {
            Driver1Controls(false);
        }

        private void Driver1ActionSetRadio_CheckedChanged(object sender, EventArgs e)
        {
            Driver1Controls(true);
        }

        #endregion === Local Methods ===

        //----------------------------------------------------------------------

        #region === GUI Control ===

        private void GUIControlToMsgBox(SDK.Action action, SDK.GUIControl control)
        {
            string sep = Separator(action);
            Driver1MsgBox.AppendText("GUI User" + sep + control.User + Environment.NewLine);
            Driver1MsgBox.AppendText("GUI Printer" + sep + control.Printer + Environment.NewLine);
            Driver1MsgBox.AppendText(Environment.NewLine);
        }

        private void SetGUIControl(SDK.GUIControl control) 
        {
            GUIUser.Checked = control.User;
            GUIPrinter.Checked = control.Printer;
        }

        private SDK.Return GetGUIControl(ref SDK.GUIControl control)
        {
            SDK.Return SDKReturn = SDK.ID_GUIControl(hSession, SDK.Action.Read, control);
            if (SDKReturn == SDK.Return.Success)
            {
                SetGUIControl(control);
            }
            else
            {
                HandleError("GetGUIControl", SDKReturn);
            }
            return SDKReturn;
        }

        private void GUIControlButton_Click(object sender, EventArgs e)
        {
            SDK.GUIControl control = new SDK.GUIControl();

            if (Driver1ActionIsGet())
            {
                if (GetGUIControl(ref control) == SDK.Return.Success)
                {
                    GUIControlToMsgBox(SDK.Action.Read, control);
                }
            }
            else
            {
                control.User    = GUIUser.Checked;
                control.Printer = GUIPrinter.Checked;

                SDK.Return SDKReturn = SDK.ID_GUIControl(hSession, SDK.Action.Write, control);
                if (SDKReturn != SDK.Return.Success)
                {
                    HandleError("SetGUIControl", SDKReturn);
                }
                else
                {
                    GUIControlToMsgBox(SDK.Action.Write, control);
                }
            }
        }

        #endregion === GUI Control ===
        
        //----------------------------------------------------------------------

        #region === Sharpness ===

        private SDK.Return GetSharpness(ref sbyte sharpness)
        {
            SDK.Return SDKReturn = SDK.ID_Sharpness(hSession, SDK.Action.Read, ref sharpness);
            if (SDKReturn == SDK.Return.Success)
            {
                SetSharpness(sharpness);
            }
            else
            {
                HandleError("GetSharpness", SDKReturn);
            }
            return SDKReturn;
        }

        private void SharpnessToMsgBox(SDK.Action action, sbyte sharpness)
        {
            string sep = Separator(action);
            Driver1MsgBox.AppendText("Sharpness" + sep + sharpness + Environment.NewLine);
            Driver1MsgBox.AppendText(Environment.NewLine);
        }

        private void SetSharpness(sbyte sharpness) 
        { 
            SharpnessUpDown.Value = sharpness; 
        }

        private void SharpnessButton_Click(object sender, EventArgs e)
        {
            sbyte sharpness = decimal.ToSByte(SharpnessUpDown.Value);

            if (Driver1ActionIsGet())
            {
                if (GetSharpness(ref sharpness) == SDK.Return.Success)
                {
                    SharpnessToMsgBox(SDK.Action.Read, sharpness);
                }
            }
            else
            {
                SDK.Return SDKReturn = SDK.ID_Sharpness(hSession, SDK.Action.Write, ref sharpness);
                if (SDKReturn != SDK.Return.Success)
                {
                    HandleError("SetSharpness", SDKReturn);
                }
                else
                {
                    SharpnessToMsgBox(SDK.Action.Write, sharpness);
                }
            }
        }

        #endregion === Sharpness ===

        //----------------------------------------------------------------------

        #region === Colour Correction ===

        Dictionary<SDK.Correction, string> correctionkp = new Dictionary<SDK.Correction, string>()
        {
            {SDK.Correction.None,            "None"},
            {SDK.Correction.Gamma1,          "Gamma1"},           
            {SDK.Correction.Gamma2,          "Gamma2"},           
            {SDK.Correction.ICC_Internal,    "ICC Internal"},
            {SDK.Correction.ICC_External,    "ICC External"},
            {SDK.Correction.Perceptual,      "Perceptual"},
            {SDK.Correction.Saturation,      "Saturation"},
            {SDK.Correction.RelColorimetric, "Rel Colorimetric"},
            {SDK.Correction.AbsColorimetric, "Abs Colorimetric"},
        };

        private void InitCorrectionCombos()
        {
            CorrectionCombo.DataSource              = new BindingSource(correctionkp, null);
            CorrectionCombo.DisplayMember           = "Value";
            ColourAreaCorrectionCombo.DataSource    = new BindingSource(correctionkp, null);
            ColourAreaCorrectionCombo.DisplayMember = "Value";
        }

        private void CorrectionToMsgBox(SDK.Action action, SDK.Correction Correction)
        {
            string sep = Separator(action);
            Driver1MsgBox.AppendText("Colour Correction" + sep + correctionkp[Correction] + Environment.NewLine);
            Driver1MsgBox.AppendText(Environment.NewLine);
        }

        private void SetCorrectionCombo(SDK.Correction Correction) 
        {
            CorrectionCombo.Text = correctionkp[Correction]; 
        }

        private SDK.Return GetColourCorrection(ref SDK.Correction Correction)
        {
            SDK.Return SDKReturn = SDK.ID_ColourCorrection(hSession, SDK.Action.Read, ref Correction);
            if (SDKReturn == SDK.Return.Success)
            {
                SetCorrectionCombo(Correction);
            }
            else
            {
                HandleError("GetColourCorrection", SDKReturn);
            }
            return SDKReturn;
        }

        private void ColourCorrectionButton_Click(object sender, EventArgs e)
        {
            SDK.Correction correction = ((KeyValuePair<SDK.Correction, string>)CorrectionCombo.SelectedItem).Key;

            if (Driver1ActionIsGet())
            {
                if (GetColourCorrection(ref correction) == SDK.Return.Success)
                {
                    CorrectionToMsgBox(SDK.Action.Read, correction);
                }
            }
            else
            {
                SDK.Return SDKReturn = SDK.ID_ColourCorrection(hSession, SDK.Action.Write, ref correction);
                if (SDKReturn != SDK.Return.Success)
                {
                    HandleError("SetColourCorrection", SDKReturn);
                }
                else
                {
                    CorrectionToMsgBox(SDK.Action.Write, correction);
                }
            }
        }

        #endregion === Colour Correction ===

        //----------------------------------------------------------------------

        #region === Print Speed ===

        Dictionary<SDK.PrintSpeed, string> printspeedkp = new Dictionary<SDK.PrintSpeed, string>()
        {
            {SDK.PrintSpeed.Normal, "Normal"},
            {SDK.PrintSpeed.High,   "High"},
        };

        private void InitPrintSpeedCombo()
        {
            PrintSpeedCombo.DataSource    = new BindingSource(printspeedkp, null);
            PrintSpeedCombo.DisplayMember = "Value";
        }

        private void PrintSpeedToMsgBox(SDK.Action action, SDK.PrintSpeed speed)
        {
            string sep = Separator(action);
            Driver1MsgBox.AppendText("Print Speed" + sep + printspeedkp[speed] + Environment.NewLine);
            Driver1MsgBox.AppendText(Environment.NewLine);
        }

        private void SetPrintSpeedCombo(SDK.PrintSpeed speed)
        {
            PrintSpeedCombo.Text = printspeedkp[speed]; 
        }

        private SDK.Return GetPrintSpeed(ref SDK.PrintSpeed speed)
        {
            SDK.Return SDKReturn = SDK.ID_PrintSpeed(hSession, SDK.Action.Read, ref speed);
            if (SDKReturn == SDK.Return.Success)
            {
                SetPrintSpeedCombo(speed);
            }
            else
            {
                HandleError("GetPrintSpeed", SDKReturn);
            }
            return SDKReturn;
        }

        private void PrintSpeedButton_Click(object sender, EventArgs e)
        {
            SDK.PrintSpeed speed = ((KeyValuePair<SDK.PrintSpeed, string>)PrintSpeedCombo.SelectedItem).Key;

            if (Driver1ActionIsGet())
            {
                if (GetPrintSpeed(ref speed) == SDK.Return.Success)
                {
                    PrintSpeedToMsgBox(SDK.Action.Read, speed);
                }
            }
            else
            {
                SDK.Return SDKReturn = SDK.ID_PrintSpeed(hSession, SDK.Action.Write, ref speed);
                if (SDKReturn != SDK.Return.Success)
                {
                    HandleError("SetPrintSpeed", SDKReturn);
                }
                else
                {
                    PrintSpeedToMsgBox(SDK.Action.Write, speed);
                }
            }
        }

        #endregion === Print Speed ===

        //----------------------------------------------------------------------

        #region === Power Levels ===

        private SDK.Return GetPowerLevels(ref SDK.PowerLevel levels)
        {
            SDK.Return SDKReturn = SDK.ID_PowerLevel(hSession, SDK.Action.Read, levels);
            if (SDKReturn == SDK.Return.Success)
            {
                SetPowerLevels(levels);
            }
            else
            {
                HandleError("GetPowerLevel", SDKReturn);
            }
            return SDKReturn;
        }

        private void PowerLevelsToMsgBox(SDK.Action action, SDK.PowerLevel powerLevel)
        {
            string sep = Separator(action);
            Driver1MsgBox.AppendText("Power Level YMC"      + sep + powerLevel.YMC + Environment.NewLine);
            Driver1MsgBox.AppendText("Power Level Resin"    + sep + powerLevel.Resin + Environment.NewLine);
            Driver1MsgBox.AppendText("Power Level Overcoat" + sep + powerLevel.Overcoat + Environment.NewLine);
            Driver1MsgBox.AppendText(Environment.NewLine);
        }

        private void SetPowerLevels(SDK.PowerLevel powerLevel)
        {
            YMCPowerUpDown.Value      = powerLevel.YMC;
            ResinPowerUpDown.Value    = powerLevel.Resin;
            OvercoatPowerUpDown.Value = powerLevel.Overcoat;
        }

        private void PowerLevelButton_Click(object sender, EventArgs e)
        {
            SDK.PowerLevel powerLevel = new SDK.PowerLevel();

            if (Driver1ActionIsGet())
            {
                if (GetPowerLevels(ref powerLevel) == SDK.Return.Success)
                {
                    PowerLevelsToMsgBox(SDK.Action.Read, powerLevel);
                }
            }
            else
            {
                powerLevel.YMC      = decimal.ToByte(YMCPowerUpDown.Value);
                powerLevel.Resin    = decimal.ToByte(ResinPowerUpDown.Value);
                powerLevel.Overcoat = decimal.ToByte(OvercoatPowerUpDown.Value);

                SDK.Return SDKReturn = SDK.ID_PowerLevel(hSession, SDK.Action.Write, powerLevel);
                if (SDKReturn != SDK.Return.Success)
                {
                    HandleError("SetPowerLevel", SDKReturn);
                }
                else
                {
                    PowerLevelsToMsgBox(SDK.Action.Write, powerLevel);
                }
            }
        }

        #endregion === Power Levels ===

        //----------------------------------------------------------------------

        #region === Resin Areas ===

        private void ResinArea_Changed(object sender, EventArgs e)
        {
            SDK.Area Area = new SDK.Area();
            SDK.Return SDKReturn = GetResinArea(((KeyValuePair<SDK.Side, string>)ResinAreaSideCombo.SelectedItem).Key,
                                                decimal.ToByte(ResinAreaNoUpDown.Value),
                                                ref Area);
            if (SDKReturn == SDK.Return.Success)
            {
                SetResinArea(Area);
            }
        }

        private SDK.Return GetResinArea(SDK.Side side, byte areaNo, ref SDK.Area area)
        {
            SDK.Return SDKReturn = SDK.ID_ResinArea(hSession, 
                                                    SDK.Action.Read, 
                                                    side,
                                                    areaNo, 
                                                    area);
            if (SDKReturn == SDK.Return.Success)
            {
                SetResinArea(area);
            }
            else
            {
                HandleError("GetResinArea", SDKReturn);
            }
            return SDKReturn;
        }

        private void ResinAreaToMsgBox(SDK.Action action, SDK.Side side, SDK.Area area)
        {
            string sep = Separator(action);
            Driver1MsgBox.AppendText("Resin Area " + sidekp[side] + " " + ResinAreaNoUpDown.Value + Environment.NewLine);
            Driver1MsgBox.AppendText("Area Left"   + sep + area.Left   + Environment.NewLine);
            Driver1MsgBox.AppendText("Area Width"  + sep + area.Width  + Environment.NewLine);
            Driver1MsgBox.AppendText("Area Bottom" + sep + area.Bottom + Environment.NewLine);
            Driver1MsgBox.AppendText("Area Height" + sep + area.Height + Environment.NewLine);
            Driver1MsgBox.AppendText(Environment.NewLine);
        }

        private void SetResinArea(SDK.Area area)
        {
            ResinAreaLeftUpDown.Value   = area.Left;
            ResinAreaWidthUpDown.Value  = area.Width;
            ResinAreaBottomUpDown.Value = area.Bottom;
            ResinAreaHeightUpDown.Value = area.Height;
        }

        private void ResinAreaButton_Click(object sender, EventArgs e)
        {
            SDK.Area area = new SDK.Area();
            SDK.Side side = ((KeyValuePair<SDK.Side, string>)ResinAreaSideCombo.SelectedItem).Key;

            if (Driver1ActionIsGet())
            {
                if (GetResinArea(side,
                                 decimal.ToByte(ResinAreaNoUpDown.Value),
                                 ref area) == SDK.Return.Success)
                {
                    ResinAreaToMsgBox(SDK.Action.Read, side, area);
                }
            }
            else
            {
                area.Left   = decimal.ToInt32(ResinAreaLeftUpDown.Value);
                area.Width  = decimal.ToInt32(ResinAreaWidthUpDown.Value);
                area.Bottom = decimal.ToInt32(ResinAreaBottomUpDown.Value);
                area.Height = decimal.ToInt32(ResinAreaHeightUpDown.Value);

                SDK.Return SDKReturn = SDK.ID_ResinArea(hSession, 
                                                              SDK.Action.Write,
                                                              side,
                                                              decimal.ToByte(ResinAreaNoUpDown.Value),
                                                              area);
                if (SDKReturn != SDK.Return.Success)
                {
                    HandleError("SetResinArea", SDKReturn);
                }
                else
                {
                    ResinAreaToMsgBox(SDK.Action.Write, side, area);
                }
            }
        }

        #endregion === Resin Areas ===

        //----------------------------------------------------------------------

        #region === Areas/Holes ===

        private void AreaHole_Changed(object sender, EventArgs e)
        {
            SDK.Area area = new SDK.Area();
            SDK.Return SDKReturn = GetAreaHole(((KeyValuePair<SDK.Side, string>)AreaHoleSideCombo.SelectedItem).Key,
                                                  ((KeyValuePair<SDK.AreaHole, string>)AreaHoleTypeCombo.SelectedItem).Key,
                                                  decimal.ToByte(AreaHoleNoUpDown.Value),
                                                  ref area);

            if (SDKReturn == SDK.Return.Success)
            {
                SetAreaHole(area);
            }
        }

        private SDK.Return GetAreaHole(SDK.Side side, SDK.AreaHole areaHoleID, byte areaNo, ref SDK.Area area)
        {
            SDK.Return SDKReturn = SDK.ID_AreaHole(hSession,
                                                   SDK.Action.Read,
                                                   side,
                                                   areaHoleID,
                                                   areaNo,
                                                   area);
            if (SDKReturn == SDK.Return.Success)
            {
                SetAreaHole(area);
            }
            else
            {
                HandleError("GetAreaHole", SDKReturn);
            }
            return SDKReturn;
        }

        private void AreaHoleToMsgBox(SDK.Action action, SDK.Side side, SDK.AreaHole type, SDK.Area area)
        {
            string sep = Separator(action);
            Driver1MsgBox.AppendText("Area/Hole "
                                     + sidekp[side] + ","
                                     + areaholekp[type] + ","
                                     + AreaHoleNoUpDown.Value
                                     + Environment.NewLine);
            Driver1MsgBox.AppendText("Area Left"   + sep + area.Left   + Environment.NewLine);
            Driver1MsgBox.AppendText("Area Width"  + sep + area.Width  + Environment.NewLine);
            Driver1MsgBox.AppendText("Area Bottom" + sep + area.Bottom + Environment.NewLine);
            Driver1MsgBox.AppendText("Area Height" + sep + area.Height + Environment.NewLine);
            Driver1MsgBox.AppendText(Environment.NewLine);
        }

        private void SetAreaHole(SDK.Area area)
        {
            AreaHoleLeftUpDown.Value   = area.Left;
            AreaHoleWidthUpDown.Value  = area.Width;
            AreaHoleBottomUpDown.Value = area.Bottom;
            AreaHoleHeightUpDown.Value = area.Height;
        }

        private void AreaHoleButton_Click(object sender, EventArgs e)
        {
            SDK.Area     area = new SDK.Area();
            SDK.Side     side = ((KeyValuePair<SDK.Side, string>)AreaHoleSideCombo.SelectedItem).Key;
            SDK.AreaHole type = ((KeyValuePair<SDK.AreaHole, string>)AreaHoleTypeCombo.SelectedItem).Key;

            if (Driver1ActionIsGet())
            {
                if (GetAreaHole(side, type, decimal.ToByte(AreaHoleNoUpDown.Value), ref area) == SDK.Return.Success)
                {
                    AreaHoleToMsgBox(SDK.Action.Read, side, type, area);
                }
            }
            else
            {
                area.Left   = decimal.ToInt32(AreaHoleLeftUpDown.Value);
                area.Width  = decimal.ToInt32(AreaHoleWidthUpDown.Value);
                area.Bottom = decimal.ToInt32(AreaHoleBottomUpDown.Value);
                area.Height = decimal.ToInt32(AreaHoleHeightUpDown.Value);

                SDK.Return SDKReturn = SDK.ID_AreaHole(hSession,
                                                             SDK.Action.Write,
                                                             side,
                                                             type,
                                                             decimal.ToByte(AreaHoleNoUpDown.Value),
                                                             area);
                if (SDKReturn != SDK.Return.Success)
                {
                    HandleError("SetAreaHole", SDKReturn);
                }
                else
                {
                    AreaHoleToMsgBox(SDK.Action.Write, side, type, area);
                }
            }
        }

        #endregion === Areas/Holes ===

        //----------------------------------------------------------------------

        #region === Rewritable Cards ===

        private SDK.Return GetRewritable(ref SDK.Rewritable rewritable)
        {
            SDK.Return SDKReturn = SDK.ID_Rewritable(hSession, SDK.Action.Read, rewritable);
            if (SDKReturn == SDK.Return.Success)
            {
                SetRewritable(rewritable);
            }
            else
            {
                HandleError("GetRewritable", SDKReturn);
            }
            return SDKReturn;
        }

        private void RewritableToMsgBox(SDK.Action action, SDK.Rewritable rewritable)
        {
            string sep = Separator(action);
            Driver1MsgBox.AppendText("Rewritable" + Environment.NewLine);
            Driver1MsgBox.AppendText("Area Left"   + sep + rewritable.EraseArea.Left   + Environment.NewLine);
            Driver1MsgBox.AppendText("Area Width"  + sep + rewritable.EraseArea.Width  + Environment.NewLine);
            Driver1MsgBox.AppendText("Area Bottom" + sep + rewritable.EraseArea.Bottom + Environment.NewLine);
            Driver1MsgBox.AppendText("Area Height" + sep + rewritable.EraseArea.Height + Environment.NewLine);
            Driver1MsgBox.AppendText("Erase Before Print" + sep + rewritable.EraseBeforePrint + Environment.NewLine);
            Driver1MsgBox.AppendText("Erase Power Start"  + sep + rewritable.ErasePowerStart  + Environment.NewLine);
            Driver1MsgBox.AppendText("Erase Power End"    + sep + rewritable.ErasePowerEnd    + Environment.NewLine);
            Driver1MsgBox.AppendText("Write Power"        + sep + rewritable.WritePower       + Environment.NewLine);
            Driver1MsgBox.AppendText(Environment.NewLine);
        }

        private void SetRewritable(SDK.Rewritable rewritable)
        {
            EraseAreaLeftUpDown.Value   = rewritable.EraseArea.Left;
            EraseAreaWidthUpDown.Value  = rewritable.EraseArea.Width;
            EraseAreaBottomUpDown.Value = rewritable.EraseArea.Bottom;
            EraseAreaHeightUpDown.Value = rewritable.EraseArea.Height;
            EraseBeforePrint.Checked    = rewritable.EraseBeforePrint;
            ErasePowerStartUpDown.Value = rewritable.ErasePowerStart;
            ErasePowerEndUpDown.Value   = rewritable.ErasePowerEnd;
            WritePowerUpDown.Value      = rewritable.WritePower;
        }

        private void RewritableButton_Click(object sender, EventArgs e)
        {
            SDK.Rewritable rewritable = new SDK.Rewritable();

            if (Driver1ActionIsGet())
            {
                if (GetRewritable(ref rewritable) == SDK.Return.Success)
                {
                    RewritableToMsgBox(SDK.Action.Read, rewritable);
                }
            }
            else
            {
                rewritable.EraseArea = new SDK.Area();
                rewritable.EraseArea.Left   = decimal.ToInt32(EraseAreaLeftUpDown.Value);
                rewritable.EraseArea.Width  = decimal.ToInt32(EraseAreaWidthUpDown.Value);
                rewritable.EraseArea.Bottom = decimal.ToInt32(EraseAreaBottomUpDown.Value);
                rewritable.EraseArea.Height = decimal.ToInt32(EraseAreaHeightUpDown.Value);
                rewritable.EraseBeforePrint = EraseBeforePrint.Checked;
                rewritable.ErasePowerStart  = decimal.ToByte(ErasePowerStartUpDown.Value);
                rewritable.ErasePowerEnd    = decimal.ToByte(ErasePowerEndUpDown.Value);
                rewritable.WritePower       = decimal.ToByte(WritePowerUpDown.Value);

                SDK.Return SDKReturn = SDK.ID_Rewritable(hSession, SDK.Action.Write, rewritable);
                if (SDKReturn != SDK.Return.Success)
                {
                    HandleError("SetRewritable", SDKReturn);
                }
                else
                {
                    RewritableToMsgBox(SDK.Action.Write, rewritable);
                }
            }
        }

        #endregion === Rewritable Cards ===

        //----------------------------------------------------------------------

        #region === Printable Areas ===

        private SDK.Return GetPrintableArea(ref SDK.Area area)
        {
            SDK.Return SDKReturn = SDK.ID_PrintableArea(hSession,
                                                        SDK.Action.Read,
                                                        area);
            if (SDKReturn == SDK.Return.Success)
            {
                SetPrintableArea(area);
            }
            else
            {
                HandleError("GetPrintableArea", SDKReturn);
            }
            return SDKReturn;
        }

        private void PrintableAreaToMsgBox(SDK.Action action, SDK.Area area)
        {
            string sep = Separator(action);
            Driver1MsgBox.AppendText("Area Left" + sep + area.Left + Environment.NewLine);
            Driver1MsgBox.AppendText("Area Width" + sep + area.Width + Environment.NewLine);
            Driver1MsgBox.AppendText("Area Bottom" + sep + area.Bottom + Environment.NewLine);
            Driver1MsgBox.AppendText("Area Height" + sep + area.Height + Environment.NewLine);
            Driver1MsgBox.AppendText(Environment.NewLine);
        }

        private void SetPrintableArea(SDK.Area area)
        {
            PrintableAreaLeftUpDown.Value = area.Left;
            PrintableAreaWidthUpDown.Value = area.Width;
            PrintableAreaBottomUpDown.Value = area.Bottom;
            PrintableAreaHeightUpDown.Value = area.Height;
        }

        private void PrintableAreaButton_Click(object sender, EventArgs e)
        {
            SDK.Area area = new SDK.Area();

            if (Driver1ActionIsGet())
            {
                if (GetPrintableArea(ref area) == SDK.Return.Success)
                {
                    PrintableAreaToMsgBox(SDK.Action.Read, area);
                }
            }
            else
            {
                area.Left   = decimal.ToInt32(PrintableAreaLeftUpDown.Value);
                area.Width  = decimal.ToInt32(PrintableAreaWidthUpDown.Value);
                area.Bottom = decimal.ToInt32(PrintableAreaBottomUpDown.Value);
                area.Height = decimal.ToInt32(PrintableAreaHeightUpDown.Value);

                SDK.Return SDKReturn = SDK.ID_PrintableArea(hSession,
                                                            SDK.Action.Write,
                                                            area);
                if (SDKReturn != SDK.Return.Success)
                {
                    HandleError("SetPrintableArea", SDKReturn);
                }
                else
                {
                    PrintableAreaToMsgBox(SDK.Action.Write, area);
                }
            }
        }

        #endregion === Printable Areas ===

        //----------------------------------------------------------------------

        #region === Resolution ===

        private SDK.Return GetResolution(ref byte resolution)
        {
            SDK.Return SDKReturn = SDK.ID_Resolution(hSession,
                                                     SDK.Action.Read,
                                                     ref resolution);
            if (SDKReturn == SDK.Return.Success)
            {
                SetResolution(resolution);
            }
            else
            {
                HandleError("GetResolution", SDKReturn);
            }
            return SDKReturn;
        }

        private void ResolutionToMsgBox(SDK.Action action, byte resolution)
        {
            Driver1MsgBox.AppendText("Resolution" 
                                     + Separator(action)
                                     + (resolution != 0 ? "600" : "300")
                                     + " x 300 DPI"
                                     + Environment.NewLine 
                                     + Environment.NewLine);
        }

        private void SetResolution(byte resolution)
        {
            if (resolution == 0)
                Radio300DPI.Checked = true;
            else
                Radio600DPI.Checked = true;
        }

        private void ResolutionButton_Click(object sender, EventArgs e)
        {
            byte resolution = 0;

            if (Driver1ActionIsGet())
            {
                if (GetResolution(ref resolution) == SDK.Return.Success)
                {
                    ResolutionToMsgBox(SDK.Action.Read, resolution);
                }
            }
            else
            {
                resolution = (byte)(Radio600DPI.Checked ? 1 : 0);
                SDK.Return SDKReturn = SDK.ID_Resolution(hSession,
                                                         SDK.Action.Write,
                                                         ref resolution);
                if (SDKReturn != SDK.Return.Success)
                {
                    HandleError("SetResolution", SDKReturn);
                }
                else
                {
                    ResolutionToMsgBox(SDK.Action.Write, resolution);
                }
            }
        }

        #endregion === Resolution ===
    }
}
